//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ServerThread.h"
#include "dMandelbrotC.h"


#pragma package(smart_init)
//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall ServerThread::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------
__fastcall ServerThread::ServerThread(bool CreateSuspended)
    : TThread(CreateSuspended)
{
   ServerBad = false;
   Recovered = false;
   Priority = tpLower;
   Socket = new TClientSocket(ImageWin);  // Owner kinda bogus, but hey.
   Socket->ClientType = ctBlocking;
   Socket->Port = 4565;

}
//---------------------------------------------------------------------------
void __fastcall ServerThread::Execute()
{

while(!Terminated)
{
 long int Iterations = 0;


 // Begin Timer:
 TDateTime StartTime = TDateTime::CurrentTime();


 try
 {
  Socket->Active= true;
  // Save Address
  Address = Socket->Socket->RemoteHost;
  IP = Socket->Socket->RemoteAddress;

  Socket->Socket->SendBuf(&SendBuf,sizeof(SendBuf));


  TWinSocketStream *pStream = new TWinSocketStream(Socket->Socket,10000);

  unsigned char InChar[10000];
  int NumberRead,index;

  index = 0;

   // Priming read.
   if (pStream->WaitForData(60000) )
    {
      index = 0;
      NumberRead = pStream->Read(&InChar,10000);
     }

  int y = SendBuf.sy;
  int x = SendBuf.sx;
  while( y <= SendBuf.ey)
  {

      while( x <= SendBuf.ex && (index < NumberRead))
      {

         ImageWin->SPool->Data[x++][y] = InChar[index];
         if (InChar[index] != 0)
         {
            Iterations += InChar[index];                  // Count # iterations.
         }
         else
         {
           Iterations += SendBuf.maxIter;
         }
         index++;
      } //end while X loop.
      // Are we done with this line?
      if (x == SendBuf.ex + 1)
          {  x = SendBuf.sx; y++; }
      // Are we out of data?
      if (index == NumberRead && (y < SendBuf.ey + 1) )
      {
       index = 0;
       if (pStream->WaitForData(60000) )
       {
         NumberRead = pStream->Read(&InChar,10000);
       }
       else
        int checkTHIS = 0;
      }
  } // end while   Y Loop



  Socket->Active = false;
  } // end TRY
  catch (...)
  {
   // We just got some type of network error, assume that the server
   // is bad.
   ServerBad = true;
   };

  // End Timer - Convert to seconds and devide by bytes to get Iterations/sec
  TDateTime EndTime = TDateTime::CurrentTime();

  Ips =((double) Iterations) / ((double)(EndTime - StartTime) * 86400.0 )  ;


  Suspend();

  } // End While Not Terminated

}
//---------------------------------------------------------------------------
