//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <stdio.h>
#include "Unit1.h"
#include "ServerPool.h"
#include "dMandelbrotC.h"
#include "ServerWindow.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TServerWin *ServerWin;
//---------------------------------------------------------------------------
__fastcall TServerWin::TServerWin(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TServerWin::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  ImageWin->ServerControls1->Checked = false;
}
//---------------------------------------------------------------------------

void TServerWin::UpdateServerList()
{

// This function will read through the servers in the pool
// in reverse order (fastest first) and list them in the list
// box.

// Clear the current items.
ServerWebLB->Clear();

for(int i =0; i < ImageWin->SPool->NumServers; i++)
{

  ServerThread *temp = ImageWin->SPool->Pool[i];

 AnsiString Hostname = temp->Address;
 AnsiString Speed = FloatToStrF((double)temp->Ips / 1024.0,AnsiString::sffGeneral,4,20);

 ServerWebLB->Items->Add(Hostname + "   " + Speed + " KI/s");

}

NumberServersEB->Text = FloatToStrF(ImageWin->SPool->NumServers, AnsiString::sffGeneral,4,4);

} // end UpdateServerList.
void __fastcall TServerWin::EstablishConnectionBTNClick(TObject *Sender)
{
 EstablishConnectionBTN->Enabled = false;
 ControlWin->RedisplayBTN->Enabled = false;

 // This button will add a server to the pool, or scan a Cblock and
 // add any servers it finds to the pool.
 if (  CBlockScanCB->Checked == true)
 {
 /*
  char base[100];

   // Add the First Server.
   ImageWin->SPool->AddServer( ServerIPEB->Text );
   UpdateServerList();

   // Use the address of the first server to find others...
   AnsiString baseAddr = ImageWin->SPool->Pool[0]->IP;

   strcpy(base,baseAddr.c_str());
   int i = strlen(base);
   while(i > 0 && base[i] !='.')
     i--;

   base[i]='\0';  // Chop off the end stuff.

  for(int i = 1; i< 255; i++)
  {
   char newIP[100];
   sprintf(newIP,"%s.%d",base,i);
   ImageWin->SPool->AddServer(newIP);
   UpdateServerList();
  }
   */
   ImageWin->SPool->ScanCblock( ServerIPEB->Text);
    UpdateServerList();
 }
 else  // Add a single server.
 {
  ImageWin->SPool->AddServer( ServerIPEB->Text );
  UpdateServerList();
 }

 if (ImageWin->SPool->NumServers > 0)
    ControlWin->RedisplayBTN->Enabled = true;


 EstablishConnectionBTN->Enabled = true;

}
//---------------------------------------------------------------------------

void __fastcall TServerWin::RemoveBTNClick(TObject *Sender)
{
  for (int i = 0; i < ServerWebLB->Items->Count; i++)
 {
  if (ServerWebLB->Selected[i])
  {
    ImageWin->SPool->RemoveServer(i);
  } // end if.
 } // end for.

 UpdateServerList();

 if (ImageWin->SPool->NumServers == 0)
 {
   ControlWin->RedisplayBTN->Enabled = false;
 }

}
//---------------------------------------------------------------------------

