//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "dMandelbrotC.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TControlWin *ControlWin;
//---------------------------------------------------------------------------
__fastcall TControlWin::TControlWin(TComponent* Owner)
    : TForm(Owner)
{
 NumbersChanged = false;
}
//---------------------------------------------------------------------------
void __fastcall TControlWin::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  ImageWin->ImageControls1->Checked = false;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::RedisplayBTNClick(TObject *Sender)
{

 // Begin Timer:
 TDateTime StartTime = TDateTime::CurrentTime();

  RenderTimeEB->Text = " Working...";
  RenderTimeEB->Update();  // show during render.
  RedisplayBTN->Enabled = false;

  if (NumbersChanged)
  {
   NumbersChanged = false;
    try
   {
    ImageWin->Imin = IMinEB->Text.ToDouble();
    ImageWin->Imax = IMaxEB->Text.ToDouble();
    ImageWin->Rmin = RMinEB->Text.ToDouble();
    ImageWin->Rmax = RMaxEB->Text.ToDouble();
    ImageWin->ImageWidth = (int) ImageWidthEB->Text.ToDouble();
    ImageWin->ImageHeight = (int) ImageHeightEB->Text.ToDouble();
    if (ImageWin->ImageWidth < 5) ImageWin->ImageWidth = 5;
    if (ImageWin->ImageHeight < 5) ImageWin->ImageHeight = 5;
   }
   catch(EConvertError &e) { return; }
   // For testing - add an error pop up if error occures.

   } // End if NumbersChanged.



   // Resize the window if needed.
   ImageWin->CheckSize();

   // Invoke the power of the server pool.
   ImageWin->SPool->RunMandelbrot(ImageWin->ImageHeight, ImageWin->ImageWidth,ImageWin->Rmin,
                        ImageWin->Rmax,ImageWin->Imin,ImageWin->Imax);

   if (ImageWin->SPool->NumServers > 0 )
     RedisplayBTN->Enabled = true;



  // End Timer - Convert to seconds - display to GUI.
  TDateTime EndTime = TDateTime::CurrentTime();
  int Seconds = ((double)(EndTime - StartTime) * 86400.0 );
  if (Seconds > 60)
  {
    AnsiString Min = FloatToStrF((double)Seconds / 60, AnsiString::sffGeneral,4,20);
    RenderTimeEB->Text =" " + Min + " minutes";
  }
  else
  {
   AnsiString Sec = FloatToStrF((double)Seconds,AnsiString::sffGeneral,4,20);
   RenderTimeEB->Text = " " +Sec + " seconds";
  }


 
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::IMinEBChange(TObject *Sender)
{
   NumbersChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::IMaxEBChange(TObject *Sender)
{
    NumbersChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::RMinEBChange(TObject *Sender)
{
  NumbersChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::RMaxEBChange(TObject *Sender)
{
  NumbersChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::ImageWidthEBChange(TObject *Sender)
{
  NumbersChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TControlWin::ImageHeightEBChange(TObject *Sender)
{
   NumbersChanged = true;
}
//---------------------------------------------------------------------------

