//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#include <stdlib.h>
#include "ServerWindow.h"
#include "dMandelbrotC.h"
#include "AboutWindow.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TImageWin *ImageWin;


//---------------------------------------------------------------------------
__fastcall TImageWin::TImageWin(TComponent* Owner)
    : TForm(Owner)
{
 SPool = new ServerPool();



 // Initial configurations.
 Imin = -1.25;
 Imax = 1.25;
 Rmin = -2.75;
 Rmax = 0.75;
 ImageWidth = 500;
 ImageHeight = 300;


}
//---------------------------------------------------------------------------

void __fastcall TImageWin::ImageControls1Click(TObject *Sender)
{
  ControlWin->Visible = !ImageControls1->Checked;
  ImageControls1->Checked = !ImageControls1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TImageWin::ServerControls1Click(TObject *Sender)
{
  ServerWin->Visible = !ServerControls1->Checked;
  ServerControls1->Checked = !ServerControls1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TImageWin::Exit1Click(TObject *Sender)
{
  // close the form.
  Close();
}
//---------------------------------------------------------------------------
// This procedure checks the size of the Image, if it's wrong it will
// resize it.
void TImageWin::CheckSize(void)
{

// Resize window if needed and it's still in the screen area.

if ( (ClientHeight != ImageHeight + 10) && (ImageHeight < Screen->Height - 80) )
    ClientHeight = ImageHeight + 10;
if ( (ClientWidth != ImageWidth + 10) && (ImageWidth < Screen->Width  - 40) )
    ClientWidth = ImageWidth + 10;


// Resize Image if needed.
if (Display->Height != ImageHeight)
    Display->Height = ImageHeight;
if (Display->Width != ImageWidth)
    Display->Width = ImageWidth;

}
void __fastcall TImageWin::DisplayMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    Drawing = true;
    Display->Picture->Bitmap->Canvas->Pen->Color = clSilver;
    Display->Picture->Bitmap->Canvas->MoveTo(X,Y);
    Origin = Point(X,Y);
    MovePt = Point(X,Y);

}
//---------------------------------------------------------------------------

void __fastcall TImageWin::DisplayMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
if (Drawing)
    {
     Display->Picture->Bitmap->Canvas->Pen->Mode = pmXor;

     Display->Picture->Bitmap->Canvas->MoveTo(Origin.x,Origin.y);
     Display->Picture->Bitmap->Canvas->LineTo(MovePt.x,Origin.y);
     Display->Picture->Bitmap->Canvas->LineTo(MovePt.x,MovePt.y);
     Display->Picture->Bitmap->Canvas->LineTo(Origin.x,MovePt.y);
     Display->Picture->Bitmap->Canvas->LineTo(Origin.x,Origin.y);

     Y = Origin.y + ((double)ImageHeight / (double)ImageWidth) * (long double) (abs(Origin.x - X) );

     Display->Picture->Bitmap->Canvas->MoveTo(Origin.x,Origin.y);
     Display->Picture->Bitmap->Canvas->LineTo(X,Origin.y);
     Display->Picture->Bitmap->Canvas->LineTo(X,Y);
     Display->Picture->Bitmap->Canvas->LineTo(Origin.x,Y);
     Display->Picture->Bitmap->Canvas->LineTo(Origin.x,Origin.y);

    } // end if
    MovePt = Point(X,Y);
    Display->Picture->Bitmap->Canvas->Pen->Mode = pmCopy;

}
//---------------------------------------------------------------------------

void __fastcall TImageWin::DisplayMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   Y = Origin.y + ((double)ImageHeight / (double)ImageWidth) * (long double) (abs(Origin.x - X) );
   Display->Picture->Bitmap->Canvas->MoveTo(Origin.x, Origin.y);
   Display->Picture->Bitmap->Canvas->MoveTo(Origin.x,Origin.y);
   Display->Picture->Bitmap->Canvas->LineTo(X,Origin.y);
   Display->Picture->Bitmap->Canvas->LineTo(X,Y);
   Display->Picture->Bitmap->Canvas->LineTo(Origin.x,Y);
   Display->Picture->Bitmap->Canvas->LineTo(Origin.x,Origin.y);

   Drawing = false;

   long double oRmax,oRmin,oImax,oImin,Rratio,Iratio;

   oRmax= Rmax; oRmin = Rmin; oImin = Imin; oImax = Imax;

   Rratio = (oRmax - oRmin) / (double) ImageWidth;
   Iratio = (oImax - oImin) / (double) ImageHeight;

   Rmin = oRmin + (Rratio * (long double) Origin.x);
   Rmax = oRmin + (Rratio * (long double) X);
   Imin = oImin + (Iratio * (long double) Origin.y);
   Imax = oImin + (Iratio * (long double) Y);

   // Put the new numbers into the Display
   AnsiString TempStr;

   TempStr = FloatToStrF(Imin, AnsiString::sffExponent,45,5);
   ControlWin->IMinEB->Text =  TempStr;

   TempStr = TempStr = FloatToStrF(Imax, AnsiString::sffExponent,45,5);
   ControlWin->IMaxEB->Text = TempStr;

   TempStr = FloatToStrF(Rmin, AnsiString::sffExponent,45,5);
   ControlWin->RMinEB->Text = TempStr;

   TempStr = FloatToStrF(Rmax, AnsiString::sffExponent,45,5);
   ControlWin->RMaxEB->Text = TempStr;

   ControlWin->RedisplayBTN->Click(); // Redraw the sucker!


}
//---------------------------------------------------------------------------

void __fastcall TImageWin::About1Click(TObject *Sender)
{
  AboutWin->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TImageWin::RedMNUClick(TObject *Sender)
{

 LOGPALETTE *LogPalette;
 HPALETTE    hNewPalette;
 RGBQUAD     rgbQuad;
 int nColors = 240;

 LogPalette = (LOGPALETTE *) malloc ((nColors * sizeof(PALETTEENTRY)) +
                                      sizeof (LOGPALETTE));

  LogPalette->palVersion = 0x300;
  LogPalette->palNumEntries = (WORD) nColors;

  rgbQuad.rgbRed = 255;
  rgbQuad.rgbGreen = 0;
  rgbQuad.rgbBlue = 0;

  for (int nIndex = 1; nIndex < nColors; nIndex++)
  {
    LogPalette->palPalEntry [nIndex].peRed   = rgbQuad.rgbRed;
    LogPalette->palPalEntry [nIndex].peGreen = rgbQuad.rgbGreen;
    LogPalette->palPalEntry [nIndex].peBlue  = rgbQuad.rgbBlue;
    LogPalette->palPalEntry [nIndex].peFlags = PC_NOCOLLAPSE;

    rgbQuad.rgbRed--;
    //rgbQuad.rgbGreen--;
    //rgbQuad.rgbBlue--;

  }
    LogPalette->palPalEntry [0].peRed   = 0;
    LogPalette->palPalEntry [0].peGreen = 0;
    LogPalette->palPalEntry [0].peBlue  = 0;

  hNewPalette = CreatePalette (LogPalette);

  ImageWin->Display->Picture->Bitmap->Palette = hNewPalette;




  //Display->Picture->Bitmap->Palette[5] = 0;
}
//---------------------------------------------------------------------------

void __fastcall TImageWin::View1Click(TObject *Sender)
{
  // Get the filename to save the image to:
  if (SaveDialog1->Execute() == TRUE)
  {
    // They want to save the image, do so.
    Display->Picture->SaveToFile(SaveDialog1->FileName);
  }
  // otherwise, do nothing.
}
//---------------------------------------------------------------------------

